<?php
/**
 * Add custom repeater fields (Title, Content, Image) to a page titled "Services"
 */

// Add meta box only on the "Services" page
add_action('add_meta_boxes', function () {
    global $post;
    if ($post && $post->post_title === 'Services') {
        add_meta_box(
            'current_expansions_box',
            'Current Expansions',
            'render_current_expansions_meta_box',
            'page',
            'normal',
            'high'
        );
    }
});

// Render the meta box content
function render_current_expansions_meta_box($post) {
    $expansions = get_post_meta($post->ID, 'current_expansions', true);
    wp_nonce_field('save_current_expansions', 'current_expansions_nonce');
    ?>
    <div id="expansions-wrapper">
        <?php
        if (!empty($expansions)) {
            foreach ($expansions as $index => $expansion) {
                ?>
                <div class="expansion-item">
                    <input type="text" name="current_expansions[<?php echo $index; ?>][title]" value="<?php echo esc_attr($expansion['title']); ?>" placeholder="Title" style="width:100%; margin-bottom:5px;" />
                    <textarea name="current_expansions[<?php echo $index; ?>][content]" placeholder="Content" style="width:100%; margin-bottom:5px;"><?php echo esc_textarea($expansion['content']); ?></textarea>
                    <input type="text" name="current_expansions[<?php echo $index; ?>][image]" class="image-url" value="<?php echo esc_url($expansion['image']); ?>" placeholder="Image URL" style="width:80%;" />
                    <button class="upload-image-button button">Upload</button>
                    <button class="remove-expansion button">Remove</button>
                </div>
                <?php
            }
        }
        ?>
    </div>
    <button id="add-expansion" class="button">Add Expansion</button>

    <script>
        jQuery(document).ready(function ($) {
            let index = <?php echo !empty($expansions) ? count($expansions) : 0; ?>;

            $('#add-expansion').on('click', function (e) {
                e.preventDefault();
                $('#expansions-wrapper').append(`
                    <div class="expansion-item">
                        <input type="text" name="current_expansions[${index}][title]" placeholder="Title" style="width:100%; margin-bottom:5px;" />
                        <textarea name="current_expansions[${index}][content]" placeholder="Content" style="width:100%; margin-bottom:5px;"></textarea>
                        <input type="text" name="current_expansions[${index}][image]" class="image-url" placeholder="Image URL" style="width:80%;" />
                        <button class="upload-image-button button">Upload</button>
                        <button class="remove-expansion button">Remove</button>
                    </div>
                `);
                index++;
            });

            $(document).on('click', '.remove-expansion', function (e) {
                e.preventDefault();
                $(this).closest('.expansion-item').remove();
            });

            $(document).on('click', '.upload-image-button', function (e) {
                e.preventDefault();
                const button = $(this);
                const input = button.siblings('.image-url');
                const customUploader = wp.media({
                    title: 'Select Image',
                    button: { text: 'Use this image' },
                    multiple: false
                }).on('select', function () {
                    const attachment = customUploader.state().get('selection').first().toJSON();
                    input.val(attachment.url);
                }).open();
            });
        });
    </script>

    <style>
        .expansion-item {
            margin-bottom: 15px;
            background: #f9f9f9;
            padding: 15px;
            border: 1px solid #ccc;
        }
    </style>
    <?php
}

// Save the repeater data
add_action('save_post', function ($post_id) {
    if (!isset($_POST['current_expansions_nonce']) || !wp_verify_nonce($_POST['current_expansions_nonce'], 'save_current_expansions')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (get_post_type($post_id) !== 'page') return;

    if (isset($_POST['current_expansions']) && is_array($_POST['current_expansions'])) {
        $clean = array_map(function ($item) {
            return [
                'title' => sanitize_text_field($item['title']),
                'content' => sanitize_textarea_field($item['content']),
                'image' => esc_url_raw($item['image']),
            ];
        }, $_POST['current_expansions']);

        update_post_meta($post_id, 'current_expansions', $clean);
    } else {
        delete_post_meta($post_id, 'current_expansions');
    }
});