<?php
add_action('add_meta_boxes', 'homepage_banner_meta_box');
function homepage_banner_meta_box() {
    add_meta_box('homepage_banners', 'Home Page Banners', 'render_homepage_banners_meta_box', 'page', 'normal', 'high');
}

function render_homepage_banners_meta_box($post) {
    // Only show if this page is the homepage
    if ((int)get_option('page_on_front') !== (int)$post->ID) {
        echo '<p>This banner section is only visible/editable on the static front page.</p>';
        return;
    }

    wp_nonce_field('save_homepage_banners', 'homepage_banners_nonce');

    $banners = get_post_meta($post->ID, '_homepage_banners', true);
    $banners = is_array($banners) ? $banners : [];
    ?>
    <div id="homepage-banners-wrapper">
        <?php foreach ($banners as $index => $banner): ?>
            <div class="banner-item">
                <textarea name="banners[<?php echo $index; ?>][title]" placeholder="Banner Title with HTML" rows="2" style="width: 40%"><?php echo esc_textarea($banner['title']); ?></textarea>
                <input type="text" name="banners[<?php echo $index; ?>][image]" value="<?php echo esc_url($banner['image']); ?>" placeholder="Banner Image URL" style="width: 50%" />
                <button class="upload-banner-image button">Upload</button>
                <button class="remove-banner button">Remove</button>
                <hr/>
            </div>
        <?php endforeach; ?>
    </div>
    <button type="button" id="add-banner" class="button">Add Banner</button>

    <script>
        jQuery(document).ready(function($) {
            let bannerIndex = <?php echo count($banners); ?>;

            $('#add-banner').click(function(e) {
                e.preventDefault();
                $('#homepage-banners-wrapper').append(`
                    <div class="banner-item">
                        <textarea name="banners[${bannerIndex}][title]" placeholder="Banner Title with HTML" rows="2" style="width: 40%"></textarea>
                        <input type="text" name="banners[${bannerIndex}][image]" placeholder="Banner Image URL" style="width: 50%" />
                        <button class="upload-banner-image button">Upload</button>
                        <button class="remove-banner button">Remove</button>
                        <hr/>
                    </div>
                `);
                bannerIndex++;
            });

            $(document).on('click', '.remove-banner', function(e) {
                e.preventDefault();
                $(this).closest('.banner-item').remove();
            });

            $(document).on('click', '.upload-banner-image', function(e) {
                e.preventDefault();
                const button = $(this);
                const input = button.prev('input');

                const customUploader = wp.media({
                    title: 'Select Banner Image',
                    button: {
                        text: 'Use this image'
                    },
                    multiple: false
                });

                customUploader.on('select', function() {
                    const attachment = customUploader.state().get('selection').first().toJSON();
                    input.val(attachment.url);
                });

                customUploader.open();
            });
        });
    </script>
    <?php
}

add_action('save_post', 'save_homepage_banners_meta_box');
function save_homepage_banners_meta_box($post_id) {
    if (!isset($_POST['homepage_banners_nonce']) || !wp_verify_nonce($_POST['homepage_banners_nonce'], 'save_homepage_banners')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (isset($_POST['banners']) && is_array($_POST['banners'])) {
        $banners_raw = array_values($_POST['banners']); // Re-index

        $allowed_html = [
            'span' => [
                'class' => [],
                'style' => [],
                'id' => [],
            ],
            'strong' => [],
            'em' => [],
            'br' => [],
        ];

        $sanitized = array_map(function($banner) use ($allowed_html) {
            return [
                'title' => wp_kses($banner['title'], $allowed_html),
                'image' => esc_url_raw($banner['image']),
                'image_id' => isset($banner['image_id']) ? intval($banner['image_id']) : '',
            ];
        }, $banners_raw);

        update_post_meta($post_id, '_homepage_banners', $sanitized);
    }
}