<?php
// Add Meta Box for Industry Carousel (Only on "Services" Page)
add_action('add_meta_boxes', function () {
    global $post;
    if ($post && ($post->post_title === 'Services' || $post->post_title === 'Home')) {
        add_meta_box(
            'industry_carousel_box',
            'Industries Carousel',
            'render_industry_carousel_meta_box',
            'page',
            'normal',
            'default'
        );
    }
});

// Render Industry Carousel Meta Box
function render_industry_carousel_meta_box($post) {
    $industries = get_post_meta($post->ID, 'industry_carousel', true);
    wp_nonce_field('save_industry_carousel', 'industry_carousel_nonce');
    ?>
    <div id="industry-carousel-wrapper">
        <?php if (!empty($industries)) :
            foreach ($industries as $index => $item) : ?>
                <div class="industry-item">
                    <input type="text" name="industry_carousel[<?php echo $index; ?>][image]" class="image-url" value="<?php echo esc_url($item['image']); ?>" placeholder="Image URL" style="width:80%;" />
                    <button class="upload-image-button button">Upload</button>
                    <button class="remove-industry button">Remove</button>
                </div>
            <?php endforeach;
        endif; ?>
    </div>
    <button id="add-industry" class="button">Add Industry Image</button>

    <script>
        jQuery(document).ready(function ($) {
            let index = <?php echo !empty($industries) ? count($industries) : 0; ?>;

            $('#add-industry').on('click', function (e) {
                e.preventDefault();
                $('#industry-carousel-wrapper').append(`
                    <div class="industry-item">
                        <input type="text" name="industry_carousel[${index}][image]" class="image-url" placeholder="Image URL" style="width:80%;" />
                        <button class="upload-image-button button">Upload</button>
                        <button class="remove-industry button">Remove</button>
                    </div>
                `);
                index++;
            });

            $(document).on('click', '.remove-industry', function (e) {
                e.preventDefault();
                $(this).closest('.industry-item').remove();
            });

            $(document).on('click', '.upload-image-button', function (e) {
                e.preventDefault();
                const button = $(this);
                const input = button.siblings('.image-url');
                const customUploader = wp.media({
                    title: 'Select Image',
                    button: { text: 'Use this image' },
                    multiple: false
                }).on('select', function () {
                    const attachment = customUploader.state().get('selection').first().toJSON();
                    input.val(attachment.url);
                }).open();
            });
        });
    </script>

    <style>
        .industry-item {
            margin-bottom: 15px;
            background: #f6f6f6;
            padding: 10px;
            border: 1px solid #ccc;
        }
    </style>
    <?php
}

// Save Industry Carousel Data
add_action('save_post', function ($post_id) {
    if (!isset($_POST['industry_carousel_nonce']) || !wp_verify_nonce($_POST['industry_carousel_nonce'], 'save_industry_carousel')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (get_post_type($post_id) !== 'page') return;

    if (isset($_POST['industry_carousel']) && is_array($_POST['industry_carousel'])) {
        $clean = array_map(function ($item) {
            return [
                'image' => esc_url_raw($item['image']),
            ];
        }, $_POST['industry_carousel']);

        update_post_meta($post_id, 'industry_carousel', $clean);
    } else {
        delete_post_meta($post_id, 'industry_carousel');
    }
});