<?php
function current_expansion() {
    ob_start();

    // Get the repeater meta data
    $expansions = get_post_meta(get_the_ID(), 'current_expansions', true);

    if (!empty($expansions)) : ?>
        <div class="current-expansion owl-carousel owl-theme">
            <?php foreach ($expansions as $expansion) :
                $title = isset($expansion['title']) ? $expansion['title'] : '';
                $content = isset($expansion['content']) ? $expansion['content'] : '';
                $image = isset($expansion['image']) ? $expansion['image'] : '';
                ?>
                <div class="item">
                    <div class="expansion-block">
                        <?php if ($image): ?>
                            <div class="expansion-img">
                                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($title); ?>" />
                            </div>
                        <?php endif; ?>
                        <div class="expansion-content">
                            <h3><?php echo esc_html($title); ?></h3>
                            <p><?php echo esc_html($content); ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif;

    return ob_get_clean();
}
add_shortcode('show_current_expansion', 'current_expansion');
?>