<?php
function job_openings() {
    ob_start(); ?>
<div class="career_files career-openings">
    <div class="career_filters" id="filter_holder">
		<div class="search-holder">
			<input type="search" class="search-input" value="" name="search" placeholder="Search" id="job_search">
    		<button type="submit" class="search-submit" name="submit" id="serch_button"><svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.4413 18.2411L22.7614 21.5595C22.9162 21.7198 23.0019 21.9345 23 22.1574C22.998 22.3803 22.9086 22.5934 22.751 22.751C22.5934 22.9086 22.3803 22.998 22.1574 23C21.9345 23.0019 21.7198 22.9162 21.5595 22.7614L18.2394 19.4413C16.0698 21.3001 13.2646 22.2464 10.4123 22.0815C7.56006 21.9167 4.88252 20.6535 2.94156 18.557C1.00059 16.4606 -0.0529362 13.6938 0.00204894 10.8373C0.057034 7.98084 1.21626 5.25668 3.23647 3.23647C5.25668 1.21626 7.98084 0.057034 10.8373 0.00204894C13.6938 -0.0529362 16.4606 1.00059 18.557 2.94156C20.6535 4.88252 21.9167 7.56006 22.0815 10.4123C22.2464 13.2646 21.3001 16.0698 19.4413 18.2394V18.2411ZM11.0501 20.4001C13.5299 20.4001 15.9081 19.415 17.6616 17.6616C19.415 15.9081 20.4001 13.5299 20.4001 11.0501C20.4001 8.57035 19.415 6.19214 17.6616 4.43868C15.9081 2.68522 13.5299 1.70013 11.0501 1.70013C8.57035 1.70013 6.19214 2.68522 4.43868 4.43868C2.68522 6.19214 1.70013 8.57035 1.70013 11.0501C1.70013 13.5299 2.68522 15.9081 4.43868 17.6616C6.19214 19.415 8.57035 20.4001 11.0501 20.4001Z" fill="#747474"></path>
</svg></button>
  		</div>
		<!-- Filter Button with SVG Icon -->
    	<div class="filter-container">
			<button class="filter-btn">
				Filter
				<svg width="24" height="22" viewBox="0 0 24 22" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M22.5273 10.6642H8.62797M3.72184 10.6642H1.71484M3.72184 10.6642C3.72184 10.0137 3.98023 9.38994 4.44016 8.93C4.9001 8.47007 5.5239 8.21168 6.17434 8.21168C6.82479 8.21168 7.44859 8.47007 7.90852 8.93C8.36846 9.38994 8.62684 10.0137 8.62684 10.6642C8.62684 11.3146 8.36846 11.9384 7.90852 12.3984C7.44859 12.8583 6.82479 13.1167 6.17434 13.1167C5.5239 13.1167 4.9001 12.8583 4.44016 12.3984C3.98023 11.9384 3.72184 11.3146 3.72184 10.6642ZM22.5273 18.0971H16.0608M16.0608 18.0971C16.0608 18.7477 15.8018 19.3722 15.3418 19.8322C14.8818 20.2922 14.2578 20.5507 13.6072 20.5507C12.9568 20.5507 12.333 20.2912 11.873 19.8312C11.4131 19.3713 11.1547 18.7475 11.1547 18.0971M16.0608 18.0971C16.0608 17.4465 15.8018 16.8231 15.3418 16.363C14.8818 15.903 14.2578 15.6446 13.6072 15.6446C12.9568 15.6446 12.333 15.9029 11.873 16.3629C11.4131 16.8228 11.1547 17.4466 11.1547 18.0971M11.1547 18.0971H1.71484M22.5273 3.23131H19.0342M14.1281 3.23131H1.71484M14.1281 3.23131C14.1281 2.58087 14.3865 1.95706 14.8464 1.49713C15.3063 1.0372 15.9302 0.778809 16.5806 0.778809C16.9027 0.778809 17.2216 0.842244 17.5191 0.965494C17.8167 1.08874 18.087 1.26939 18.3148 1.49713C18.5425 1.72486 18.7232 1.99523 18.8464 2.29278C18.9697 2.59033 19.0331 2.90924 19.0331 3.23131C19.0331 3.55338 18.9697 3.87229 18.8464 4.16984C18.7232 4.46739 18.5425 4.73775 18.3148 4.96549C18.087 5.19322 17.8167 5.37387 17.5191 5.49712C17.2216 5.62037 16.9027 5.68381 16.5806 5.68381C15.9302 5.68381 15.3063 5.42542 14.8464 4.96549C14.3865 4.50555 14.1281 3.88175 14.1281 3.23131Z" stroke="#747474" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"/>
				</svg>
			</button>

			<!-- Dropdown Menu -->
			<div class="filter-dropdown">
				<?php
				$job_types = get_terms(array(
					'taxonomy'   => 'job_type', // Change to your actual taxonomy name
					'hide_empty' => false,      // Show even if no jobs are assigned
				));

				if (!empty($job_types) && !is_wp_error($job_types)) {
					foreach ($job_types as $job_type) {
						echo '<label><input type="checkbox" value="' . esc_attr($job_type->slug) . '"> ' . esc_html($job_type->name) . '</label>';
					}
				} else {
					echo '<p>No job types found.</p>';
				}
				?>
			</div>
    	</div>
    </div>
<div class="career_entries_list" id="post-container">
    <ul id="job_listings"></ul> <!-- Empty list, jobs load here -->
	<div class="paginationwrap"></div>
</div>
</div>
<!-- JavaScript for Toggle -->
    <script>
        document.querySelector(".filter-btn").addEventListener("click", function(event) {
            event.stopPropagation(); // Prevents dropdown from closing immediately
            document.querySelector(".filter-container").classList.toggle("active");
        });

        // Close dropdown when clicking outside
        document.addEventListener("click", function(e) {
            if (!document.querySelector(".filter-container").contains(e.target)) {
                document.querySelector(".filter-container").classList.remove("active");
            }
        });
		
		jQuery(document).ready(function ($) {
    function loadJobs(paged = 1) {
        let searchQuery = $('#job_search').val();
        let selectedTypes = [];
        $('.filter-dropdown input[type="checkbox"]:checked').each(function () {
            selectedTypes.push($(this).val());
        });
		var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
        $.ajax({
            url: ajaxurl, // WordPress AJAX URL
            type: 'POST',
            data: {
                action: 'fetch_job_openings',
                search: searchQuery,
                job_types: selectedTypes,
                paged: paged
            },
            beforeSend: function () {
                $('.career_entries_list ul').html('<div class="loading-holder"><p>Loading jobs...</p></div>'); // Show loading message
            },
            success: function (response) {
                $('.career_entries_list ul').html(response.posts);
				$('.paginationwrap').html(response.pagination);
            }
        });
    }

    // Search event
    $('#serch_button').on('click', function (e) {
        e.preventDefault();
        loadJobs();
    });

    // Checkbox filter event
    $('.filter-dropdown input[type="checkbox"]').on('change', function () {
        loadJobs();
    });

    // Pagination click event (uses event delegation)
    $(document).on('click', '.pagination-btn', function () {
        let page = $(this).data('page');
        loadJobs(page);
		jQuery('html, body').animate({
			scrollTop: $('#post-container').offset().top
		}, 500);
    });
	// Pagination click event
            $(document).on('click', '.pagination li a', function(e) {
                e.preventDefault();
                page = $(this).data('page');
				loadJobs(page);
            });
    // Load first set of jobs on page load
    loadJobs();
});

    </script>
<?php
return ob_get_clean();
}
add_shortcode('show_job_openings', 'job_openings');
?>