<?php
function latest_insights_listing() {
    ob_start();
    $args = array(
        'post_type' => 'blog', 
		'order' => 'DESC' ,
		'posts_per_page' => 3,
		'post_status' => 'publish',
    );
    $query = new WP_Query($args);
?>
<div class="insight-list-main">
    <div id="post-container" class="blog-row new-blog">
	<?php if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
             $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
				$thumbnail_id  = get_post_thumbnail_id(get_the_ID());
  				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );		
				$date = get_the_date();
				$post_date=date('F j, Y', strtotime($date));
				$tags = get_the_terms(get_the_ID(), 'post_tag'); 
				$custom_author_name = get_post_meta(get_the_ID(), '_blog_author', true);
				$category = wp_get_post_terms(get_the_ID(), 'blog_category', array('fields' => 'names'));
				if (!empty($category)) : $i=1; 
                    foreach ($category as $cat) : 
                        $item_category=$cat;
						if($i==1){
							break;
						}
                    endforeach;
                endif;
            ?>
					<div class="blog-each-holder case-study-each">
					<div class="blogs-info">
							<a href="<?php echo get_the_permalink(); ?>">
							<div class="img-txt1">
								<img decoding="async" src="<?php echo $featured_img_url; ?>" alt="<?php echo $thumbnail_alt; ?>" class="featured-blog-img">
							</div>
							<div class="blog-content">
								<div class="insight-cat">
									<p><?php echo $item_category; ?> | 5 min read</p>
								</div>
								<div class="img-txt2">
									<p><?php echo mb_strimwidth(get_the_title(), 0, 80, '...'); ?></p>
								</div>
								<div class="tag-holder">
								<?php if ($tags && !is_wp_error($tags)) : ?>
									<?php foreach ($tags as $tag) : ?>
										<span class="pills_button"><?php echo esc_html($tag->name); ?></span>
									<?php endforeach; ?>
							<?php endif; ?>
								</div>
								<div class="author-holder">
									<?php if (!empty($custom_author_name)) {
											echo '<p class="case-study-author">' . esc_html($custom_author_name) . '</p>';
										} else {
											echo '<p class="case-study-author">' . esc_html(get_the_author_meta('display_name')) . '</p>'; // Fallback to default author
										} ?>
								</div>
								<div class="blog-last">
									<p><svg width="18" height="11" viewBox="0 0 18 11" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.00893 2.95947C7.72404 2.95947 6.67871 4.00325 6.67871 5.28614C6.67871 6.56903 7.72404 7.61281 9.00893 7.61281C10.2938 7.61281 11.3392 6.56903 11.3392 5.28614C11.3392 4.00325 10.2938 2.95947 9.00893 2.95947ZM9.00893 7.16836C7.96916 7.16836 7.12316 6.32414 7.12316 5.28614C7.12316 4.24814 7.96916 3.40392 9.00893 3.40392C10.0487 3.40392 10.8945 4.24814 10.8945 5.28614C10.8945 6.32414 10.0487 7.16836 9.00893 7.16836Z" fill="black" stroke="black" stroke-width="0.727273"/>
<path d="M9 0.507324C5.436 0.507324 2.37111 2.46932 1 5.2851C2.37111 8.10088 5.436 10.0629 9 10.0629C12.5638 10.0629 15.6289 8.10088 17 5.2851C15.6289 2.46932 12.5638 0.507324 9 0.507324ZM9 9.61844C5.80022 9.61844 2.88111 7.92466 1.498 5.2851C2.88111 2.64555 5.80022 0.951769 9 0.951769C12.1996 0.951769 15.1189 2.64555 16.5022 5.2851C15.1189 7.92466 12.1996 9.61844 9 9.61844Z" fill="black" stroke="black" stroke-width="0.727273"/>
</svg> 3k Views</p>
								</div>
							</div>
							</a>
						</div>
					</div>
            <?php
        }
		wp_reset_postdata();
    }?>
	</div>

</div>
<?php
return ob_get_clean();
}
add_shortcode('show_latest_insights_listing', 'latest_insights_listing');
?>